/*
 * Random utilities for GM related stuff
 */
#include <stdio.h>

#include <gm.h>

/*
 * gm_event_str - return a string describing the type of a GM event
 */

static struct event_name {
	char *str;
	int type;
} Names[] = {

  {"GM_NO_RECV_EVENT", 0},
  {"GM_SENDS_FAILED_EVENT", 1},
  {"GM_ALARM_EVENT", 2},
  {"GM_SENT_EVENT", 3},
  {"_GM_SLEEP_EVENT", 4},
  {"GM_RAW_RECV_EVENT", 5},
  {"GM_BAD_SEND_DETECTED_EVENT", 6},
  {"GM_SEND_TOKEN_VIOLATION_EVENT", 7},
  {"GM_RECV_TOKEN_VIOLATION_EVENT", 8},
  {"GM_BAD_RECV_TOKEN_EVENT", 9},
  {"GM_ALARM_VIOLATION_EVENT", 10},
  {"GM_RECV_EVENT", 11},
  {"GM_HIGH_RECV_EVENT", 12},
  {"GM_PEER_RECV_EVENT", 13},
  {"GM_HIGH_PEER_RECV_EVENT", 14},
  {"GM_FAST_RECV_EVENT", 15},
  {"GM_FAST_HIGH_RECV_EVENT", 16},
  {"GM_FAST_PEER_RECV_EVENT", 17},
  {"GM_FAST_HIGH_PEER_RECV_EVENT", 18},
  {"GM_REJECTED_SEND_EVENT", 19},
  {"GM_ORPHANED_SEND_EVENT", 20},
  {"_GM_DIRECTED_SEND_NOTIFICATION_EVENT", 21},
  {"GM_BAD_RESEND_DETECTED_EVENT", 24},
  {"GM_DROPPED_SEND_EVENT", 25},
  {"GM_BAD_SEND_VMA_EVENT", 26},
  {"GM_BAD_RECV_VMA_EVENT", 27},
  {"_GM_FLUSHED_ALARM_EVENT", 28},
  {"GM_SENT_TOKENS_EVENT", 29},
  {"GM_IGNORE_RECV_EVENT", 30},
  {"GM_NEW_NO_RECV_EVENT", 128},
  {"GM_NEW_SENDS_FAILED_EVENT", 129},
  {"GM_NEW_ALARM_EVENT", 130},
  {"GM_NEW_SENT_EVENT", 131},
  {"_GM_NEW_SLEEP_EVENT", 132},
  {"GM_NEW_RAW_RECV_EVENT", 133},
  {"GM_NEW_BAD_SEND_DETECTED_EVENT", 134},
  {"GM_NEW_SEND_TOKEN_VIOLATION_EVENT", 135},
  {"GM_NEW_RECV_TOKEN_VIOLATION_EVENT", 136},
  {"GM_NEW_BAD_RECV_TOKEN_EVENT", 137},
  {"GM_NEW_ALARM_VIOLATION_EVENT", 138},
  {"GM_NEW_RECV_EVENT", 139},
  {"GM_NEW_HIGH_RECV_EVENT", 140},
  {"GM_NEW_PEER_RECV_EVENT", 141},
  {"GM_NEW_HIGH_PEER_RECV_EVENT", 142},
  {"GM_NEW_FAST_RECV_EVENT", 143},
  {"GM_NEW_FAST_HIGH_RECV_EVENT", 144},
  {"GM_NEW_FAST_PEER_RECV_EVENT", 145},
  {"GM_NEW_FAST_HIGH_PEER_RECV_EVENT", 146},
  {"GM_NEW_REJECTED_SEND_EVENT", 147},
  {"GM_NEW_ORPHANED_SEND_EVENT", 148},
  {"_GM_NEW_DIRECTED_SEND_NOTIFICATION_EVENT", 149},
  {"GM_NEW_FREE_SEND_TOKEN_EVENT", 150},
  {"GM_NEW_FREE_HIGH_SEND_TOKEN_EVENT", 151},
  {"GM_NEW_BAD_RESEND_DETECTED_EVENT", 152},
  {"GM_NEW_DROPPED_SEND_EVENT", 153},
  {"GM_NEW_BAD_SEND_VMA_EVENT", 154},
  {"GM_NEW_BAD_RECV_VMA_EVENT", 155},
  {"_GM_NEW_FLUSHED_ALARM_EVENT", 156},
  {"GM_NEW_SENT_TOKENS_EVENT", 157},
  {"GM_NEW_IGNORE_RECV_EVENT", 158},
  {NULL, -1}
};

char *
gm_event_str(
	union gm_recv_event *event)
{
	int type;
	struct event_name *np;

	type = gm_ntoh_u8(event->recv.type);

	for (np = Names; np->ln_type >= 0; ++np) {
		if (np->ln_type == type) {
			return np->str;
		}
	}

	return "Unknown type";
}
